IF OBJECT_ID('p_plug_Farma_tipoRegistro_quatorze') IS NOT NULL
	BEGIN
		DROP PROCEDURE p_plug_Farma_tipoRegistro_quatorze
	END
 
GO 
CREATE procedure [dbo].[p_plug_Farma_tipoRegistro_quatorze] (@filial int, @data  date,  @cd_emp int=1)
as
BEGIN
	set nocount on;
	/*
	--Esse SQL tem como objetivo trazer os cancelamentos de vendas do dia
	 */

	 Create table #TmpCancel ( tipoRegistro tinyint
									, dataReferenciaVenda date
									, tipoNotaVenda		tinyint
									, numeroNota		int 
									, valorNota		money
									, serieNota		varchar(30)
									, serieEcf		varchar(30)
									, vinculoVenda	tinyint
									, cd_cli		int 
									, cd_vd			int )


	  /*********************************************************************************************************************/
	  /*Conforme alinhado com plugpharma Priscila, vendas canceladas no mesmo dia não devem ser enviadas. Neste caso, no itec não existem cancelamentos em dias diferentes. E sim devoluções.*/

	 --insert into #TmpCancel
	 --SELECT
	 --          14 AS tipoRegistro
	 --        , ECF.dt_vd AS dataReferenciaVenda
	 --        , 3 AS tipoNotaVenda
	 --        , ECF.nr_ecf AS numeroNota
	 --        , ECF.vlr_vd AS valorNota
	 --        , COALESCE(SERIE.serie, 999) AS serieNota
	 --        , CX.nr_serie_imp AS serieEcf
	 --        , 1 AS vinculoVenda
	 --        , ECF.cd_cli
	 --        , ECF.cd_vd
	 --   FROM
	 --        pdv_vd ECF
	 --        INNER JOIN pdv_cx CX ON CX.cd_emp = ECF.cd_emp
	 --                                AND CX.cd_filial = ECF.cd_filial
	 --                                AND CX.cd_cx = ECF.cd_cx
	 --        LEFT JOIN pdv_cx_est_nf_serie CXSERIE ON CXSERIE.cd_ctr = CX.cd_ctr_serie
	 --        LEFT JOIN est_nf_serie SERIE ON SERIE.cd_emp = CXSERIE.cd_emp
	 --                                        AND SERIE.cd_nf_serie = CXSERIE.cd_nf_serie
	 --        LEFT JOIN pdv_vd_tef TEF ON TEF.cd_emp = ECF.cd_emp
	 --                                    AND TEF.cd_filial = ECF.cd_filial
	 --                                    AND TEF.cd_vd = ECF.cd_vd
	 --   WHERE ECF.cd_emp = @cd_emp
	 --         AND ECF.st_vd = 1
	 --         AND ECF.cd_filial = @filial
	 --         AND ECF.dt_vd = @data
	 --         AND ECF.vlr_vd > 0

	insert into #TmpCancel
	SELECT
			   14 AS tipoRegistro
			 , VD.dt_vd AS dataReferenciaVenda
			 , 3 AS tipoNotaVenda
			 , nfce.nr_nf AS numeroNota
			 , VD.vlr_vd AS valorNota
			 , nfce.serie AS serieNota
			 , 'ZZZ' AS serieEcf
			 , 1 AS vinculoVenda
			 , VD.cd_cli
			 , VD.cd_vd
		FROM
			 pdv_vd VD
			 INNER JOIN pdv_vd_pdv_vd_nfce VDNFCE ON VD.cd_emp = VDNFCE.cd_emp
													 AND VD.cd_filial = VDNFCE.cd_filial
													 AND VD.cd_vd = VDNFCE.cd_vd
			 INNER JOIN pdv_vd_nfce NFCE ON VDNFCE.cd_emp = NFCE.cd_emp
											AND VDNFCE.cd_filial = NFCE.cd_filial
											AND VDNFCE.cd_nfce = NFCE.cd_nfce
			 LEFT JOIN pdv_vd_nfce_cancel CANCEL ON CANCEL.cd_nfce = VDNFCE.cd_nfce
			 LEFT JOIN pdv_vd_tef TEF ON TEF.cd_emp = VD.cd_emp
										 AND TEF.cd_filial = VD.cd_filial
										 AND TEF.cd_vd = VD.cd_vd
		WHERE VD.cd_emp = @cd_emp
			  AND VD.cd_filial = @filial
			  AND VD.dt_vd = @data
			  AND VD.vlr_vd > 0
			  AND CANCEL.cd_cancel IS NOT NULL
			  AND VD.dt_vd < CONVERT(date, CANCEL.dt_recbto)
			  AND VD.st_vd = 1


	/*********************************************************************************************************************/

		SELECT
			   tiporegistro
			 , datareferenciavenda
			 , tiponotavenda
			 , numeronota
			 , valornota
			 , serienota
			 , serieecf
			 , vinculovenda
		FROM
			(SELECT
					   tiporegistro
					 , datareferenciavenda
					 , tiponotavenda
					 , numeronota
					 , valornota
					 , serienota
					 , serieecf
					 , vinculovenda
					 , CLIENTES.cd_cli
					 , cd_vd
				FROM
					 #TmpCancel VENDAS
					 INNER JOIN (SELECT ROW_NUMBER() OVER(ORDER BY CLI.cd_cli ASC) AS numeroReg
										 , CLI.cd_cli
									FROM
										 rc_cli CLI
										 INNER JOIN glb_cid CID ON CID.cd_cid = CLI.cd_cid
									WHERE CLI.cd_cli IN( SELECT cd_cli FROM #TmpCancel )) AS CLIENTES ON 
									CLIENTES.cd_cli = VENDAS.cd_cli
			) AS CANCELAMENTOS;
END